/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275rr;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxInfo {
    private static String bundleName = "ibm.nways.jdm8275rr.Resources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final String PropertiesFile = "properties/Jdm8275rr.txt";
    public static final String PROPNAME = "BoxInfo.jdm8275rr.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8275rr.WCDefault";
    public static final int TIMEOUT_REPEAT = 5;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    public static final int Model_416 = 1;
    public static final OID Model_416SysOID = new OID(".1.3.6.1.4.1.2.6.157");
    public static final int Num_Slots = 2;
    public static final int RASID = 19;
    public static final int RASSUB = 9;
    private OIDInfo oidInfo;
    private UFCInfo ufcInfo;
    private GenModel deviceModel;
    private GenModel systemModel;
    private GenModel portModel;
    private GenModel UFCModel;
    private GenModel HwModel;
    private GenModel interfaceModel;
    private JdmBrowser deviceBrowser;
    private GraphicPanel deviceGraphic;
    private int deviceStatus;
    private OID deviceSysOID;
    private int agentVersion;
    private int deviceType;
    private Integer[] ufcVectorArray;
    private boolean isApplication;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        String string = "BoxInfo";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string);
        }
        this.oidInfo = new OIDInfo();
        this.ufcInfo = new UFCInfo();
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        try {
            modelInfo = this.deviceModel.getInfo("Initial");
            serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "Device not responding" + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), this.getNLSString("deviceName"));
            } else {
                this.deviceSysOID = new OID(serializable.toString());
                if (!this.oidInfo.containsKey(this.deviceSysOID)) {
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string, "Wrong device. SysOID = " + this.deviceSysOID);
                    }
                    this.deviceStatus = 3;
                    new WrongSysOidMsg(this.deviceBrowser.getFrame(), this.getNLSString("deviceName"));
                } else {
                    this.deviceStatus = 1;
                    if (this.deviceSysOID.equals(Model_416SysOID)) {
                        this.deviceType = 1;
                    }
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string, "The sys oid is " + this.deviceSysOID);
                    }
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string, "This corresponds to model " + this.deviceType);
                    }
                    if (!this.getNecessaryModels()) {
                        this.deviceStatus = 4;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "Error getting inital sysoid data");
            }
            RAS.logException(19, 9, this, string, exception);
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, this, string);
        }
    }

    private boolean getNecessaryModels() {
        boolean bl = true;
        String string = null;
        String string2 = "getNecessaryModels";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string2);
            RAS.trace(19, 9, this, string2, "Attempting to retrieve the models: ");
            RAS.trace(19, 9, this, string2, "System - PortControl - DeviceInfo - Interface - AgentHardwareVPD");
        }
        try {
            string = "System";
            this.systemModel = (GenModel)this.deviceModel.getComponent(string);
            string = "PortControl";
            this.portModel = (GenModel)this.deviceModel.getComponent(string);
            string = "DeviceInfo";
            this.UFCModel = (GenModel)this.deviceModel.getComponent(string);
            string = "Interface";
            this.interfaceModel = (GenModel)this.deviceModel.getComponent(string);
            string = "AgentHardwareVPD";
            this.HwModel = (GenModel)this.deviceModel.getComponent(string);
        }
        catch (Exception exception) {
            bl = false;
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string2, "Trouble getting component " + string);
            }
            RAS.logException(19, 9, this, string2, exception);
        }
        if (bl && RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, string2, "Got all the models successfully");
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, this, string2);
        }
        return bl;
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public int getAgentVersion() {
        return this.agentVersion;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public GraphicPanel getDeviceGraphic() {
        String string = "getNecessaryModels";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string);
        }
        if (this.deviceGraphic != null) {
            return this.deviceGraphic;
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)graphicHelp);
        if (this.deviceStatus == 1) {
            this.setupLayout(this.deviceBrowser, PropertiesFile);
            this.getUFCInfo();
            graphicContainer.add((GraphicContainer)this.createFrontView());
            this.deviceGraphic = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
        } else {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "No information to construct the device graphic is available.");
            }
            Label label = new Label(this.getNLSString("NoGraphic"), 1);
            label.setFont(new Font("Arial", 1, 14));
            label.setLocation(new Point(35, 0));
            graphicContainer.add(label);
            this.deviceGraphic = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, this, string);
        }
        return this.deviceGraphic;
    }

    public CookieTray createFrontView() {
        Object object;
        Serializable serializable;
        Object object2;
        WidgetCookie widgetCookie;
        String string;
        String[] stringArray;
        Point point;
        int n;
        String string2;
        String string3;
        String string4;
        String string5;
        Vector<CookieTray> vector;
        int n2;
        CookieTray cookieTray;
        String string6;
        OID oID;
        block50: {
            oID = this.deviceSysOID;
            string6 = null;
            cookieTray = null;
            n2 = 0;
            vector = new Vector<CookieTray>(2);
            string5 = new String();
            string4 = new String("ibm.nways.jdm8275rr.eui.PortControlPanel");
            string3 = new String("/ibm/nways/jdm8275rr/" + this.oidInfo.getImage(oID));
            string2 = new String(this.oidInfo.getModel(oID));
            n = this.oidInfo.getNumPorts(oID);
            point = new Point(-1, -1);
            stringArray = new String[3];
            string = "createFrontView";
            if (RAS.isEnabled(19, 9)) {
                RAS.enter(19, 9, this, string);
            }
            try {
                string5 = new String(string2.substring(5));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                ++n2;
                if (!RAS.isEnabled(19, 9)) break block50;
                RAS.trace(19, 9, this, string, "An exception ocurred while attempting to retrieve info");
            }
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, string, "Attempting to display " + string2);
        }
        try {
            cookieTray = new CookieTray(bundleName, this.oidInfo.getPosition(oID), string3, string2, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        }
        catch (Exception exception) {
            ++n2;
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "There was an error creating a graphic image !!!");
                RAS.trace(19, 9, this, string, "Call was CookieTray ( " + bundleName + ", " + string3 + ", " + string2 + ", " + this.deviceBrowser + ", " + this.systemModel + ", ibm.nways.mib2.eui.SystemPanel)");
            }
            RAS.logException(19, 9, this, string, exception);
        }
        if (n2 > 0) {
            return cookieTray;
        }
        int n3 = 0;
        while (n3 < this.oidInfo.getNumOfExtras(oID)) {
            string6 = new String(String.valueOf(string5) + this.oidInfo.getExtras(oID, n3));
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "Attempting to create port " + string6);
            }
            try {
                widgetCookie = new WidgetCookie(string6, bundleName, null, serPath, null, this.deviceBrowser, 22, string4);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "There was an error creating a graphic image !!!");
                    RAS.trace(19, 9, this, string, "When attempted to create widget cookie " + string6);
                }
                RAS.logException(19, 9, this, string, exception);
            }
            ++n3;
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, string, "Created extra ports successfully");
        }
        int n4 = 1;
        while (n4 <= 2) {
            int n5 = n4;
            Integer n6 = this.ufcVectorArray[n4];
            if (n6 != null && n6 != 254) {
                String string7 = this.ufcInfo.getName(n6);
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "Retrieving " + string7 + " for slot " + n5);
                }
                String string8 = this.ufcInfo.getImage(n6);
                object2 = new String("/ibm/nways/gifs/24_scale/horizontal/" + string8);
                int n7 = 0;
                serializable = new Point(this.oidInfo.getSlotCoords(oID, n5));
                if (!((Point)serializable).equals(point)) {
                    try {
                        object = new CookieTray(bundleName, (Point)serializable, (String)object2, string7, this.deviceBrowser, this.UFCModel, "ibm.nways.jdm8275rr.eui.UnitIdPanel");
                        while ((n7 = n5 - vector.size()) > 0) {
                            vector.addElement(null);
                        }
                        vector.addElement((CookieTray)object);
                        stringArray[n5] = string7;
                    }
                    catch (Exception exception) {
                        ++n2;
                        if (RAS.isEnabled(19, 9)) {
                            RAS.trace(19, 9, this, string, "There was an error creating the graphic for a UFC !!!");
                            RAS.trace(19, 9, this, string, "When attempted to create cookie tray " + (String)object2);
                        }
                        RAS.logException(19, 9, this, string, exception);
                    }
                } else if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "Error , there is no slot number " + n5 + " in this box");
                }
            }
            ++n4;
        }
        Object object3 = null;
        boolean bl = true;
        int n8 = 0;
        while (n8 < 5 && bl) {
            block51: {
                Vector vector2;
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "Retrieving the port information, attempt = " + n8);
                }
                try {
                    vector2 = this.portModel.getRestOfInfo("Graphics", "default", (ModelInfo)object3, null);
                    int n9 = 1;
                    while (n9 <= vector2.size()) {
                        object2 = (ModelInfo)vector2.elementAt(n9 - 1);
                        Integer n10 = null;
                        serializable = null;
                        object = null;
                        bl = false;
                        if (((ModelInfo)object2).timeoutDetected) {
                            bl = true;
                            if (RAS.isEnabled(19, 9)) {
                                RAS.trace(19, 9, this, string, "TimeOUTS !! while adding ports ...");
                            }
                            if (n9 > 1) {
                                --n8;
                            }
                            break;
                        }
                        Serializable serializable2 = ((ModelInfo)object2).get("Index.Port");
                        Serializable serializable3 = ((ModelInfo)object2).get("Index.Slot");
                        Serializable serializable4 = ((ModelInfo)object2).get("Graphics.SwPortCtrlIfIndex");
                        if (!(serializable2 instanceof Integer || serializable3 instanceof Integer || serializable4 instanceof Integer)) {
                            bl = true;
                            if (RAS.isEnabled(19, 9)) {
                                RAS.trace(19, 9, this, string, "Bad data !! while adding ports ...");
                            }
                            if (n9 > 1) {
                                --n8;
                            }
                            break;
                        }
                        n10 = (Integer)serializable2;
                        serializable = (Integer)serializable3;
                        object = (Integer)serializable4;
                        object3 = object2;
                        ModelInfo modelInfo = new ModelInfo();
                        if ((Integer)serializable != 1 + this.oidInfo.getNumSlots(oID)) {
                            String string9;
                            modelInfo.add("Index.Unit", new Integer(1));
                            modelInfo.add("Index.Port", n10);
                            modelInfo.add("Index.Slot", serializable);
                            if (n10 <= n && (Integer)serializable == 0) {
                                string6 = new String(String.valueOf(string5) + "Port" + n9);
                                try {
                                    widgetCookie = new WidgetCookie(string6, bundleName, modelInfo, serPath, this.portModel, this.deviceBrowser, 18);
                                    cookieTray.AddWidget(widgetCookie);
                                    string9 = widgetCookie.GetFlyover().getTranslation();
                                    widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(String.valueOf(string9) + serializable));
                                    widgetCookie.SetAction(this.portModel, modelInfo, string4);
                                }
                                catch (Exception exception) {
                                    ++n2;
                                    if (RAS.isEnabled(19, 9)) {
                                        RAS.trace(19, 9, this, string, "Error: There was an exception");
                                        RAS.trace(19, 9, this, string, "Error: When attempted to create widget cookie = " + string6);
                                    }
                                    RAS.logException(19, 9, this, string, exception);
                                }
                            } else {
                                string9 = new String();
                                if ((Integer)serializable <= 2) {
                                    string9 = stringArray[(Integer)serializable];
                                }
                                if (string9.length() != 0 && !string9.equals("unknownMod")) {
                                    string6 = new String("h" + string9 + "Port" + n10);
                                    try {
                                        widgetCookie = new WidgetCookie(string6, bundleName, modelInfo, serPath, this.portModel, this.deviceBrowser, 18);
                                        String string10 = widgetCookie.GetFlyover().getTranslation();
                                        widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(String.valueOf(string10) + serializable));
                                        widgetCookie.SetAction(this.portModel, modelInfo, string4);
                                        ((CookieTray)vector.elementAt((Integer)serializable)).AddWidget(widgetCookie);
                                    }
                                    catch (Exception exception) {
                                        if (RAS.isEnabled(19, 9)) {
                                            RAS.trace(19, 9, this, string, "Got an exception when creating a port ");
                                            RAS.trace(19, 9, this, string, "while attampting to create " + string6);
                                        }
                                        RAS.logException(19, 9, this, string, exception);
                                    }
                                }
                            }
                        }
                        ++n9;
                    }
                }
                catch (Exception exception) {
                    vector2 = new Vector();
                    if (!RAS.isEnabled(19, 9)) break block51;
                    RAS.trace(19, 9, this, string, "In BoxInfo() had trouble getting ports model");
                }
            }
            ++n8;
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, string, "Finished retrieving the port information successfully");
        }
        int n11 = 0;
        while (n11 < vector.size()) {
            if (vector.elementAt(n11) != null) {
                cookieTray.add((GraphicContainer)((CookieTray)vector.elementAt(n11)));
            }
            ++n11;
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, this, string);
        }
        return cookieTray;
    }

    public void getUFCInfo() {
        this.ufcVectorArray = new Integer[3];
        Vector vector = null;
        boolean bl = true;
        String string = "getUFCInfo";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string);
        }
        try {
            Serializable serializable;
            ModelInfo modelInfo;
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "Getting the UFC information from source 1 ");
            }
            vector = this.UFCModel.getRestOfInfo("Graphics", "default", null, null);
            bl = false;
            if (vector.size() > 0) {
                modelInfo = (ModelInfo)vector.elementAt(0);
                if (!modelInfo.timeoutDetected) {
                    Serializable serializable2 = modelInfo.get("Graphics.SwDevInfoDeviceExpansionSlot1");
                    if (serializable2 instanceof Integer) {
                        this.ufcVectorArray[1] = (Integer)serializable2;
                    }
                    if ((serializable = modelInfo.get("Graphics.SwDevInfoDeviceExpansionSlot2")) instanceof Integer) {
                        this.ufcVectorArray[2] = (Integer)serializable;
                    }
                }
            }
            if (this.ufcVectorArray[1] == null || this.ufcVectorArray[2] == null) {
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string, "Getting the UFC information from source 2");
                }
                vector = this.HwModel.getRestOfInfo("Graphics", "default", null, null);
                bl = false;
                int n = 0;
                while (n < vector.size()) {
                    int n2;
                    modelInfo = (ModelInfo)vector.elementAt(n);
                    if (!(modelInfo.timeoutDetected || (serializable = modelInfo.get("Index.VPD")) instanceof Integer && (n2 = ((Integer)serializable).intValue()) != 1)) {
                        Serializable serializable3 = modelInfo.get("Index.Slot");
                        Serializable serializable4 = modelInfo.get("Graphics.AgentHardwareVPDType");
                        if (serializable3 instanceof Integer) {
                            int n3 = (Integer)serializable3;
                            if (serializable4 instanceof Integer) {
                                Integer n4;
                                this.ufcVectorArray[n3] = n4 = new Integer((Integer)serializable4 - 1);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string, "In getUFCInfo() -Exception getting DeviceInfoModel");
            }
            RAS.logException(19, 9, this, string, exception);
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, string, "Done getting the UFC information");
            RAS.exit(19, 9, this, string);
        }
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string);
        }
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        this.deviceModel = null;
        this.portModel = null;
        this.systemModel = null;
        this.UFCModel = null;
        this.HwModel = null;
        this.interfaceModel = null;
        if (this.oidInfo != null) {
            this.oidInfo.dispose();
        }
        if (this.ufcInfo != null) {
            this.ufcInfo.dispose();
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, this, string);
        }
    }

    private void setupLayout(JdmBrowser jdmBrowser, String string) {
        Object object;
        Properties properties = null;
        String string2 = "setupLayout";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, this, string2);
        }
        try {
            object = new URL(jdmBrowser.getDocumentBase(), string);
            properties = new Properties();
            properties.load(((URL)object).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 9, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)string);
            RAS.logException(19, 9, this, string2, exception);
            properties = null;
        }
        JdmLayout jdmLayout = (JdmLayout)jdmBrowser.getLayout();
        if (properties != null) {
            int n = new Integer((String)((Hashtable)properties).get("layout.scheme"));
            jdmLayout.setScheme(n);
            object = (String)((Hashtable)properties).get("layout.fractions");
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 9, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 9, this, string2, (Exception)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
                return;
            }
        } else {
            int n = 0;
            jdmLayout.setScheme(n);
        }
    }

    public String getNLSString(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                string2 = myResources.getString(string);
            }
            catch (Exception exception) {
                try {
                    string2 = commonResources.getString(string);
                }
                catch (Exception exception2) {
                    string2 = string;
                    if (!RAS.isEnabled(19, 9)) break block4;
                    RAS.trace(19, 9, this, "getNLSString", "No NLS translation for string " + string);
                }
            }
        }
        return string2;
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID(Model_416SysOID);
            Integer n = new Integer(2);
            Integer n2 = new Integer(16);
            this.oidTable.create(oID);
            Hashtable hashtable = this.oidTable.getHash(oID);
            hashtable.put("Model", "8275-M416");
            hashtable.put("Image", "8275-M416.gif");
            hashtable.put("Position", new Point(30, 25));
            hashtable.put("Number of Slots", n);
            hashtable.put("Number of ports", n2);
            Vector<Object> vector = new Vector<Object>(n);
            vector.addElement(new Point(42, 50));
            vector.addElement(new Point(331, 50));
            hashtable.put("Coords for Slots", vector);
            hashtable.put("Number of extra stuff", new Integer(1));
            vector = new Vector();
            vector.addElement("RS232");
            hashtable.put("Extras", vector);
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public String getImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Image");
        }

        public Point getPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Position");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public int getNumPorts(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of ports");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slots")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slots")).elementAt(n - 1);
        }

        public int getNumOfExtras(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }

        public void dispose() {
            this.oidTable.clear();
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(Integer n) {
            try {
                this.put(n, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(Integer n) {
            if (this.containsKey(n)) {
                return (Hashtable)this.get(n);
            }
            return (Hashtable)this.get(new Integer(999));
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            Integer n = new Integer(1);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "FASTETHER");
            this.ufcTypes.getProp(n).put("Image", "hFASTETHER.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            n = new Integer(2);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "FASTETHERFX");
            this.ufcTypes.getProp(n).put("Image", "hFASTETHERFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(8));
            n = new Integer(256);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "unknownMod");
            this.ufcTypes.getProp(n).put("Image", "hBlackUnknown.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(0));
            n = new Integer(999);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "BAD");
            this.ufcTypes.getProp(n).put("Image", "none");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(0));
        }

        public String getName(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Name");
        }

        public String getImage(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Image");
        }

        public int getNumPorts(Integer n) {
            return (Integer)this.ufcTypes.getProp(n).get("Number of ports");
        }

        public void dispose() {
            this.ufcTypes.clear();
        }
    }
}

